<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('vendor_id')->unsigned();
			$table->string('name', 150);
			$table->string('phone', 55);
			$table->string('whatsapp_number', 55);
			$table->string('email', 100)->unique();
			$table->string('password', 100);
			$table->string('address_lat', 100)->nullable();
			$table->string('address_long', 100)->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->enum('target_client_gender', array('1', '2', '3'));
			$table->enum('status', array('1', '2'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}