<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 150)->nullable();
			$table->string('phone', 55)->unique();
			$table->string('whatsapp_number', 55)->nullable();
			$table->string('email', 100)->nullable();
			$table->enum('gender', array('1', '2'))->nullable();
			$table->integer('age')->nullable();
			$table->date('birth_date')->nullable();
			$table->string('address_lat', 55)->nullable();
			$table->string('address_long', 55)->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->integer('otp')->nullable();
			$table->string('image', 150)->nullable();
			$table->enum('status', array('1', '2'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}