<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBatchInquiryItemTable extends Migration {

	public function up()
	{
		Schema::create('batch_inquiry_item', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('iban', 20)->index();
			$table->integer('user_id')->index();
			$table->bigInteger('iban_inquiry_id')->unsigned()->nullable();
			$table->bigInteger('kook_id')->unsigned()->nullable()->index();
			$table->boolean('is_cached')->default(0);
			$table->double('cost')->nullable()->default('0');
			$table->string('gate', 20)->nullable()->default('saman');
			$table->integer('batch_request_id')->unsigned()->index();
			$table->integer('try_count')->nullable()->default('0');
			$table->string('status', 20)->index()->default('waite');
			$table->boolean('is_failed')->index()->default(0);
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('batch_inquiry_item');
	}
}