<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBatchRequestTable extends Migration {

	public function up()
	{
		Schema::create('batch_request', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type', 20)->default('iban_inqury');
			$table->string('file_path', 255)->nullable();
			$table->bigInteger('user_id')->index();
			$table->string('status', 20)->default('waite');
			$table->timestamp('scheduled_for')->nullable();
			$table->string('priority', 20)->default('normal');
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('batch_request');
	}
}