<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cnpj_cpf', 'customer_name', 'status');

	public function account()
	{
		return $this->hasMany('App\Models\Account');
	}

}