<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotifsTable extends Migration {

	public function up()
	{
		Schema::create('notifs', function(Blueprint $table) {
			$table->uuid('id');
			$table->string('type');
			$table->morphs('notifiable');
			$table->text('data');
			$table->timestamp('read_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('notifs');
	}
}