<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Achievements extends Eloquent {

	protected $table = 'achievements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getActivity()
	{
		return $this->hasMany('Extra_curricular_activity', 'act_id');
	}

	public function getStudent()
	{
		return $this->belongsTo('Student', 'stu_id');
	}

}