<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventVolunteersTable extends Migration {

	public function up()
	{
		Schema::create('event_volunteers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id')->unsigned();
			$table->integer('volunteer_id')->unsigned();
			$table->boolean('is_approved')->nullable()->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('event_volunteers');
	}
}