<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('type_id')->unsigned()->index();
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->bigInteger('phone');
			$table->string('email', 100);
			$table->string('password');
			$table->boolean('is_active')->nullable()->default(0);
			$table->boolean('is_approved')->nullable()->default(0);
			$table->boolean('is_suspend')->nullable()->default(0);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}