<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('vendor_id')->unsigned();
			$table->enum('status', array('pending', 'paid', 'shipped', 'delivered', 'cancelled'));
			$table->double('sub_total');
			$table->double('delivary_charge');
			$table->double('service_charge');
			$table->double('discount');
			$table->double('total');
			$table->text('shipping_address');
			$table->enum('payment_method', array('wallet', 'credit_card', 'cash'));
			$table->double('total_profit_margin');
			$table->string('order_no');
			$table->string('delivary_code');
			$table->bigInteger('address_id')->unsigned();
			$table->text('cancelled_reason');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}