<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CartItem extends Eloquent {

	protected $table = 'carts_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function cart()
	{
		return $this->belongsTo('Cart');
	}

	public function item()
	{
		return $this->belongsTo('Product');
	}

}