<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function vendor()
	{
		return $this->belongsTo('Vendor');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function items()
	{
		return $this->hasMany('OrderItem');
	}

}