<?php

namespace App\Entities\Billing;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('xero_id');

	public function user()
	{
		return $this->belongsTo('User');
	}

}