<?php

namespace App\Entities\Courses;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Plan extends Eloquent {

	protected $table = 'plans';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Course()
	{
		return $this->belongsTo('Course');
	}

	public function enrollments()
	{
		return $this->hasMany('Enrolment');
	}

}