<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('city_id')->unsigned()->nullable();
			$table->integer('center_id')->unsigned()->nullable();
			$table->integer('district_id')->unsigned()->nullable();
			$table->string('mobile');
			$table->string('whatsapp');
			$table->text('location_iframe');
			$table->timestamps();
			$table->string('branch_google_url');
			$table->text('desc');
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}