<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotesTable extends Migration {

	public function up()
	{
		Schema::create('notes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('note_type', array('person', 'payment'));
			$table->integer('payment_id')->unsigned()->default('0');
			$table->integer('person_id')->unsigned()->default('0');
			$table->string('text', 250);
		});
	}

	public function down()
	{
		Schema::drop('notes');
	}
}