<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('payment_type', array('membership', 'camp', 'donation'));
			$table->string('payment_currency', 3)->default('USD');
			$table->decimal('payment_amount');
			$table->integer('paying_person')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}