<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->foreign('primary_member_id')->references('id')->on('members')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('paying_person')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('presenter', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('volunteer', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_staffing_presenter', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_staffing_presenter', function(Blueprint $table) {
			$table->foreign('presenter_id')->references('id')->on('presenter')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_staffing_volunteer', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_staffing_volunteer', function(Blueprint $table) {
			$table->foreign('volunteer_id')->references('id')->on('volunteer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_attendees', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_attendees', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_attendees', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activity_attendees', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_person_id_foreign');
		});
		Schema::table('members', function(Blueprint $table) {
			$table->dropForeign('members_primary_member_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_payment_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_person_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_paying_person_foreign');
		});
		Schema::table('activity', function(Blueprint $table) {
			$table->dropForeign('activity_event_id_foreign');
		});
		Schema::table('presenter', function(Blueprint $table) {
			$table->dropForeign('presenter_person_id_foreign');
		});
		Schema::table('volunteer', function(Blueprint $table) {
			$table->dropForeign('volunteer_person_id_foreign');
		});
		Schema::table('activity_staffing_presenter', function(Blueprint $table) {
			$table->dropForeign('activity_staffing_presenter_activity_id_foreign');
		});
		Schema::table('activity_staffing_presenter', function(Blueprint $table) {
			$table->dropForeign('activity_staffing_presenter_presenter_id_foreign');
		});
		Schema::table('activity_staffing_volunteer', function(Blueprint $table) {
			$table->dropForeign('activity_staffing_volunteer_activity_id_foreign');
		});
		Schema::table('activity_staffing_volunteer', function(Blueprint $table) {
			$table->dropForeign('activity_staffing_volunteer_volunteer_id_foreign');
		});
		Schema::table('event_attendees', function(Blueprint $table) {
			$table->dropForeign('event_attendees_event_id_foreign');
		});
		Schema::table('event_attendees', function(Blueprint $table) {
			$table->dropForeign('event_attendees_person_id_foreign');
		});
		Schema::table('activity_attendees', function(Blueprint $table) {
			$table->dropForeign('activity_attendees_activity_id_foreign');
		});
		Schema::table('activity_attendees', function(Blueprint $table) {
			$table->dropForeign('activity_attendees_person_id_foreign');
		});
	}
}