<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Course extends Model 
{

    protected $table = 'courses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function genre()
    {
        return $this->hasOne('Genre', 'id');
    }

    public function instrument()
    {
        return $this->hasOne('Instrument', 'id');
    }

    public function artist()
    {
        return $this->hasOne('Artist', 'id');
    }

    public function teacher()
    {
        return $this->hasOne('Teacher', 'id');
    }

    public function level()
    {
        return $this->hasOne('Level', 'id');
    }

    public function comments()
    {
        return $this->morphMany('Comment', 'commentable');
    }

    public function episodes()
    {
        return $this->hasMany('Episode', 'course_id');
    }

}