<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 200);
			$table->string('last_name', 200);
			$table->string('email', 250);
			$table->string('password', 255);
			$table->boolean('sex');
			$table->string('avatar_img', 255)->unique()->nullable();
			$table->text('bio')->nullable();
			$table->datetime('last_login')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('teachers');
	}
}