<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('downloads', function(Blueprint $table) {
			$table->foreign('show_id')->references('id')->on('shows')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->foreign('feed_id')->references('id')->on('feeds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('downloads', function(Blueprint $table) {
			$table->dropForeign('downloads_show_id_foreign');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->dropForeign('downloads_feed_id_foreign');
		});
	}
}