<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembresTable extends Migration {

	public function up()
	{
		Schema::create('membres', function(Blueprint $table) {
			$table->increments('id');
			$table->string('pseudo');
			$table->string('nom');
			$table->string('prenom');
			$table->string('sexe', 2);
			$table->string('telephone');
			$table->string('password');
			$table->string('email');
			$table->string('avatar');
			$table->boolean('banni')->nullable()->default(0);
			$table->datetime('date');
			$table->string('confirmation_code');
			$table->boolean('confirmed')->default(0);
			$table->string('locale')->default('fr');
			$table->string('emplacement');
			$table->string('api_key');
			$table->rememberToken();
		});
	}

	public function down()
	{
		Schema::drop('membres');
	}
}