<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('leagues', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('standings', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('standings', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('standings', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('standings', function(Blueprint $table) {
			$table->foreign('round_id')->references('id')->on('rounds')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fixtures', function(Blueprint $table) {
			$table->foreign('team_home')->references('id')->on('teams')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fixtures', function(Blueprint $table) {
			$table->foreign('team_away')->references('id')->on('teams')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fixtures', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fixtures', function(Blueprint $table) {
			$table->foreign('round_id')->references('id')->on('rounds')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fixture_events', function(Blueprint $table) {
			$table->foreign('fixture_id')->references('id')->on('fixtures')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fixture_events', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('league_participations', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('league_participations', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('favorite_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('favorite_leagues', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('leagues', function(Blueprint $table) {
			$table->dropForeign('leagues_country_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_country_id_foreign');
		});
		Schema::table('standings', function(Blueprint $table) {
			$table->dropForeign('standings_team_id_foreign');
		});
		Schema::table('standings', function(Blueprint $table) {
			$table->dropForeign('standings_league_id_foreign');
		});
		Schema::table('standings', function(Blueprint $table) {
			$table->dropForeign('standings_season_id_foreign');
		});
		Schema::table('standings', function(Blueprint $table) {
			$table->dropForeign('standings_round_id_foreign');
		});
		Schema::table('fixtures', function(Blueprint $table) {
			$table->dropForeign('fixtures_team_home_foreign');
		});
		Schema::table('fixtures', function(Blueprint $table) {
			$table->dropForeign('fixtures_team_away_foreign');
		});
		Schema::table('fixtures', function(Blueprint $table) {
			$table->dropForeign('fixtures_league_id_foreign');
		});
		Schema::table('fixtures', function(Blueprint $table) {
			$table->dropForeign('fixtures_round_id_foreign');
		});
		Schema::table('fixture_events', function(Blueprint $table) {
			$table->dropForeign('fixture_events_fixture_id_foreign');
		});
		Schema::table('fixture_events', function(Blueprint $table) {
			$table->dropForeign('fixture_events_team_id_foreign');
		});
		Schema::table('league_participations', function(Blueprint $table) {
			$table->dropForeign('league_participations_team_id_foreign');
		});
		Schema::table('league_participations', function(Blueprint $table) {
			$table->dropForeign('league_participations_league_id_foreign');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->dropForeign('rounds_league_id_foreign');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->dropForeign('rounds_season_id_foreign');
		});
		Schema::table('favorite_countries', function(Blueprint $table) {
			$table->dropForeign('favorite_countries_country_id_foreign');
		});
		Schema::table('favorite_leagues', function(Blueprint $table) {
			$table->dropForeign('favorite_leagues_league_id_foreign');
		});
	}
}