<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->string('id')->primary();
			$table->string('reference_id');
			$table->string('amount');
			$table->date('service_required_date');
			$table->string('customer_id');
			$table->timestamps();
			$table->softDeletes();
			$table->time('service_required_time');
			$table->enum('request_type', array('urgent', 'normal', 'sos', 'group', 'royal', 'subscription'));
			$table->string('service_area_id');
			$table->string('vendor_id');
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}