<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->string('id')->primary();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('profile_pic');
			$table->string('id_proof');
			$table->string('address_proof');
			$table->string('phone')->unique();
			$table->enum('phone_verified', array('yes', 'no'));
			$table->enum('email_verified', array('yes', 'no'));
			$table->string('address');
			$table->string('pin_code');
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->enum('gender', array('male', 'female', 'other'));
			$table->timestamps();
			$table->string('paytm_id');
			$table->string('bank_name');
			$table->string('bank_branch_name');
			$table->string('account_number');
			$table->string('ifsc_code');
			$table->softDeletes();
			$table->enum('payment_type', array('bank', 'paytm', 'other'));
			$table->time('working_start_time');
			$table->string('working_end_time');
			$table->string('username');
			$table->date('date_of_birth');
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}