<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrescriptionsTable extends Migration {

	public function up()
	{
		Schema::create('prescriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('doctor_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->date('prescription_date');
			$table->string('notes', 191);
			$table->integer('product_id')->unsigned();
			$table->string('dosage', 191);
			$table->string('duration', 191);
			$table->string('instrucation', 191);
		});
	}

	public function down()
	{
		Schema::drop('prescriptions');
	}
}