<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('packages_data', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('status_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('status_data', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tone_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tone_data', function(Blueprint $table) {
			$table->foreign('tone_id')->references('id')->on('tone')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('variants_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('variants_data', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('levels_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('levels_data', function(Blueprint $table) {
			$table->foreign('level_id')->references('id')->on('levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->foreign('tone_id')->references('id')->on('tone')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->foreign('level_id')->references('id')->on('levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->foreign('variant_id')->references('id')->on('variants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('history_write', function(Blueprint $table) {
			$table->foreign('content_id')->references('id')->on('contents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('history_write', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blogs_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blogs_data', function(Blueprint $table) {
			$table->foreign('blog_id')->references('id')->on('blogs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ads_data', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ads_data', function(Blueprint $table) {
			$table->foreign('ad_id')->references('id')->on('ads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transaction', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('result', function(Blueprint $table) {
			$table->foreign('content_id')->references('id')->on('contents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('packages_data', function(Blueprint $table) {
			$table->dropForeign('packages_data_package_id_foreign');
		});
		Schema::table('status_data', function(Blueprint $table) {
			$table->dropForeign('status_data_lang_id_foreign');
		});
		Schema::table('status_data', function(Blueprint $table) {
			$table->dropForeign('status_data_status_id_foreign');
		});
		Schema::table('tone_data', function(Blueprint $table) {
			$table->dropForeign('tone_data_lang_id_foreign');
		});
		Schema::table('tone_data', function(Blueprint $table) {
			$table->dropForeign('tone_data_tone_id_foreign');
		});
		Schema::table('variants_data', function(Blueprint $table) {
			$table->dropForeign('variants_data_lang_id_foreign');
		});
		Schema::table('variants_data', function(Blueprint $table) {
			$table->dropForeign('variants_data_variant_id_foreign');
		});
		Schema::table('levels_data', function(Blueprint $table) {
			$table->dropForeign('levels_data_lang_id_foreign');
		});
		Schema::table('levels_data', function(Blueprint $table) {
			$table->dropForeign('levels_data_level_id_foreign');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->dropForeign('contents_status_id_foreign');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->dropForeign('contents_tone_id_foreign');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->dropForeign('contents_level_id_foreign');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->dropForeign('contents_lang_id_foreign');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->dropForeign('contents_variant_id_foreign');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->dropForeign('contents_user_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_package_id_foreign');
		});
		Schema::table('history_write', function(Blueprint $table) {
			$table->dropForeign('history_write_content_id_foreign');
		});
		Schema::table('history_write', function(Blueprint $table) {
			$table->dropForeign('history_write_user_id_foreign');
		});
		Schema::table('blogs_data', function(Blueprint $table) {
			$table->dropForeign('blogs_data_lang_id_foreign');
		});
		Schema::table('blogs_data', function(Blueprint $table) {
			$table->dropForeign('blogs_data_blog_id_foreign');
		});
		Schema::table('ads_data', function(Blueprint $table) {
			$table->dropForeign('ads_data_lang_id_foreign');
		});
		Schema::table('ads_data', function(Blueprint $table) {
			$table->dropForeign('ads_data_ad_id_foreign');
		});
		Schema::table('transaction', function(Blueprint $table) {
			$table->dropForeign('transaction_user_id_foreign');
		});
		Schema::table('result', function(Blueprint $table) {
			$table->dropForeign('result_content_id_foreign');
		});
	}
}