<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchasesTable extends Migration {

	public function up()
	{
		Schema::create('purchases', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reference_no', 191);
			$table->integer('user_id');
			$table->integer('warehouse_id');
			$table->integer('supplier_id');
			$table->integer('item');
			$table->double('total_qty');
			$table->double('total_discount');
			$table->double('total_tax');
			$table->double('total_cost');
			$table->double('order_tax_rate')->nullable();
			$table->double('order_tax')->nullable();
			$table->double('order_discount')->nullable();
			$table->double('shipping_cost')->nullable();
			$table->double('grand_total')->nullable();
			$table->double('paid_amount');
			$table->integer('status');
			$table->integer('payment_status');
			$table->string('document', 191);
			$table->text('note');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('purchases');
	}
}