<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnsTable extends Migration {

	public function up()
	{
		Schema::create('returns', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reference_no', 191);
			$table->integer('user_id');
			$table->integer('customer_id');
			$table->integer('warehouse_id');
			$table->integer('biller_id');
			$table->integer('account_id');
			$table->integer('item');
			$table->double('total_qty');
			$table->double('total_discount');
			$table->double('total_tax');
			$table->double('total_price');
			$table->double('order_tax_rate');
			$table->double('order_tax');
			$table->double('grand_total');
			$table->string('document', 191);
			$table->text('return_note');
			$table->text('staff_note');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('returns');
	}
}