<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('email', 191);
			$table->string('remember_token', 100);
			$table->string('phone', 191);
			$table->string('company_name', 191);
			$table->integer('role_id');
			$table->integer('biller_id');
			$table->integer('warehouse_id');
			$table->tinyInteger('is_active');
			$table->tinyInteger('is_deleted');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}