<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillsTable extends Migration {

	public function up()
	{
		Schema::create('bills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->double('amount');
			$table->integer('branch_id');
			$table->string('invoice_number')->nullable();
			$table->integer('vendor_id');
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('bills');
	}
}