<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->double('amount');
			$table->string('invoice_number')->nullable();
			$table->string('client_name');
			$table->integer('branch_id');
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}