<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoginsTable extends Migration {

	public function up()
	{
		Schema::create('logins', function(Blueprint $table) {
			$table->string('id', 8)->default('NA');
			$table->string('user_id', 256)->default('NA');
			$table->string('doctor_id', 256);
			$table->string('user_agent');
			$table->string('mac_id', 32)->default('NA');
			$table->string('ip_address', 64)->default('NA');
			$table->string('geolocation', 64);
			$table->enum('status', array('logged_in', 'logged_out'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('logins');
	}
}