<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIntercambiosTable extends Migration {

	public function up()
	{
		Schema::create('intercambios', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_cliente')->unsigned()->nullable();
			$table->integer('id_patio')->unsigned()->nullable();
			$table->char('entrada_salida');
			$table->datetime('fecha_registro');
			$table->string('destino', 100);
			$table->integer('id_usuario_registro')->unsigned()->nullable();
			$table->integer('id_usuario_ult_mod')->unsigned()->nullable();
			$table->string('foto_firma_chofer', 100);
			$table->string('foto_firma_guardia', 100);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('intercambios');
	}
}