<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLogEntriesTable extends Migration {

	public function up()
	{
		Schema::create('log_entries', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('log_id')->unsigned();
			$table->integer('junction_id')->unsigned();
			$table->tinyInteger('set_number');
			$table->smallInteger('weight');
			$table->smallInteger('reps');
			$table->timestamp('time_recorded');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('log_entries');
	}
}