<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonsTable extends Migration {

	public function up()
	{
		Schema::create('persons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('lastname');
			$table->string('middlename');
			$table->string('email');
			$table->integer('phone')->unsigned()->index();
			$table->boolean('is_main')->index();
			$table->integer('company_id')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('persons');
	}
}