<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable()->index();
			$table->string('login')->nullable()->index();
			$table->datetime('custom_date')->nullable()->index();
			$table->float('balance')->nullable();
			$table->integer('traffic_mothly')->unsigned()->nullable();
			$table->integer('traffic_planed')->nullable();
			$table->integer('traffic_regularity')->unsigned()->nullable();
			$table->integer('company_id')->nullable()->index();
			$table->integer('status_id')->nullable()->index();
			$table->datetime('status_updated_at')->nullable()->index();
			$table->datetime('next_contact_date')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}