<?php

namespace App;

class Prestation extends Eloquent {

	protected $table = 'prestation';
	public $timestamps = false;
	protected $visible = array('titre', 'description');

	public function ville()
	{
		return $this->hasOne('App\Ville');
	}

	public function jour()
	{
		return $this->hasOne('App\Jour');
	}

	public function reservation()
	{
		return $this->hasMany('App\Reservation');
	}

	public function disponibilites()
	{
		return $this->hasMany('App\Disponibilites');
	}

	public function utilisateur()
	{
		return $this->hasOne('App\Utilisateur');
	}

	public function categorie()
	{
		return $this->hasOne('App\Categorie');
	}

}