<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('about_us');
			$table->float('longitude');
			$table->float('latitude');
			$table->string('address');
			$table->string('facebook', 100)->nullable();
			$table->string('twitter', 100)->nullable();
			$table->string('linked_in', 100)->nullable();
			$table->string('google_plus', 100)->nullable();
			$table->string('Instagram', 100)->nullable();
			$table->string('youtube', 100)->nullable();
			$table->string('snap_chat', 100)->nullable();
			$table->string('mobile', 100);
			$table->string('phone', 100);
			$table->string('email', 100);
			$table->string('logo', 100);
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}