<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidatTable extends Migration {

	public function up()
	{
		Schema::create('Candidat', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->integer('NumBac')->unique()->unsigned();
			$table->string('Nom', 20);
			$table->string('Prenom', 20);
			$table->date('DateNaissance');
			$table->integer('AnneeBac');
			$table->string('Filiale', 20);
			$table->string('MoyenneBac');
			$table->double('NoteSport1')->nullable();
			$table->double('NoteSport2', 2,2);
			$table->enum('AvisMedical', array('Apte', 'Inapte'))->nullable();
			$table->enum('EtatDossier', array('Satisfait', 'NonSatisfait'))->nullable();
			$table->integer('GroupeID')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Candidat');
	}
}