<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('main_addresses', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_services', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('manual_parameters', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('manual_parameters', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('submitted_data', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('submitted_data', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('program_service', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('programs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('program_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_program', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('company_program', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('programs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_template', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_template', function(Blueprint $table) {
			$table->foreign('template_id')->references('id')->on('templates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ranges', function(Blueprint $table) {
			$table->foreign('template_id')->references('id')->on('templates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('main_addresses', function(Blueprint $table) {
			$table->dropForeign('main_addresses_company_id_foreign');
		});
		Schema::table('invoice_details', function(Blueprint $table) {
			$table->dropForeign('invoice_details_company_id_foreign');
		});
		Schema::table('company_services', function(Blueprint $table) {
			$table->dropForeign('company_services_company_id_foreign');
		});
		Schema::table('company_services', function(Blueprint $table) {
			$table->dropForeign('company_services_service_id_foreign');
		});
		Schema::table('manual_parameters', function(Blueprint $table) {
			$table->dropForeign('manual_parameters_company_id_foreign');
		});
		Schema::table('manual_parameters', function(Blueprint $table) {
			$table->dropForeign('manual_parameters_user_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('submitted_data', function(Blueprint $table) {
			$table->dropForeign('submitted_data_company_id_foreign');
		});
		Schema::table('submitted_data', function(Blueprint $table) {
			$table->dropForeign('submitted_data_user_id_foreign');
		});
		Schema::table('program_service', function(Blueprint $table) {
			$table->dropForeign('program_service_program_id_foreign');
		});
		Schema::table('program_service', function(Blueprint $table) {
			$table->dropForeign('program_service_service_id_foreign');
		});
		Schema::table('company_program', function(Blueprint $table) {
			$table->dropForeign('company_program_company_id_foreign');
		});
		Schema::table('company_program', function(Blueprint $table) {
			$table->dropForeign('company_program_program_id_foreign');
		});
		Schema::table('service_template', function(Blueprint $table) {
			$table->dropForeign('service_template_service_id_foreign');
		});
		Schema::table('service_template', function(Blueprint $table) {
			$table->dropForeign('service_template_template_id_foreign');
		});
		Schema::table('ranges', function(Blueprint $table) {
			$table->dropForeign('ranges_template_id_foreign');
		});
	}
}