<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTable extends Migration {

	public function up()
	{
		Schema::create('programs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('year', 4);
			$table->string('name', 255);
			$table->float('max_perc_co_financing', 3,2);
			$table->timestamp('date_of_announcement');
			$table->timestamp('submission_deadline')->nullable();
			$table->tinyInteger('is_state_aid')->default('0');
			$table->tinyInteger('is_min_aid')->default('0');
			$table->float('max_bfp_sum');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('programs');
	}
}