<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('member', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('nutritionist', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->foreign('subscriptionplan_id')->references('id')->on('subscriptionplan')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('nutritionist_id')->references('user_id')->on('nutritionist')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('member_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('assaigned_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('assaigned_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('question_options', function(Blueprint $table) {
			$table->foreign('qid')->references('qcode')->on('question')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->foreign('qid')->references('qcode')->on('question')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->foreign('member_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->foreign('nutrition_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('subscription_history', function(Blueprint $table) {
			$table->foreign('member_id')->references('user_id')->on('member')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('subscription_history', function(Blueprint $table) {
			$table->foreign('subscriptionplan_id')->references('id')->on('subscriptionplan')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('nutritionist_id')->references('user_id')->on('nutritionist')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('member_id')->references('user_id')->on('member')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('dreamplans', function(Blueprint $table) {
			$table->foreign('nutritionist_id')->references('user_id')->on('nutritionist')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('dreamplans', function(Blueprint $table) {
			$table->foreign('member_id')->references('user_id')->on('member')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('member_nutritionist', function(Blueprint $table) {
			$table->foreign('member_id')->references('user_id')->on('member')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('member_nutritionist', function(Blueprint $table) {
			$table->foreign('nutritionist_id')->references('user_id')->on('nutritionist')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('member', function(Blueprint $table) {
			$table->dropForeign('member_user_id_foreign');
		});
		Schema::table('nutritionist', function(Blueprint $table) {
			$table->dropForeign('nutritionist_user_id_foreign');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->dropForeign('subscription_user_id_foreign');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->dropForeign('subscription_subscriptionplan_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_nutritionist_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_member_id_foreign');
		});
		Schema::table('assaigned_roles', function(Blueprint $table) {
			$table->dropForeign('assaigned_roles_user_id_foreign');
		});
		Schema::table('assaigned_roles', function(Blueprint $table) {
			$table->dropForeign('assaigned_roles_role_id_foreign');
		});
		Schema::table('question_options', function(Blueprint $table) {
			$table->dropForeign('question_options_qid_foreign');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->dropForeign('answer_qid_foreign');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->dropForeign('answer_member_id_foreign');
		});
		Schema::table('answer', function(Blueprint $table) {
			$table->dropForeign('answer_nutrition_id_foreign');
		});
		Schema::table('subscription_history', function(Blueprint $table) {
			$table->dropForeign('subscription_history_member_id_foreign');
		});
		Schema::table('subscription_history', function(Blueprint $table) {
			$table->dropForeign('subscription_history_subscriptionplan_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_nutritionist_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_member_id_foreign');
		});
		Schema::table('dreamplans', function(Blueprint $table) {
			$table->dropForeign('dreamplans_nutritionist_id_foreign');
		});
		Schema::table('dreamplans', function(Blueprint $table) {
			$table->dropForeign('dreamplans_member_id_foreign');
		});
		Schema::table('member_nutritionist', function(Blueprint $table) {
			$table->dropForeign('member_nutritionist_member_id_foreign');
		});
		Schema::table('member_nutritionist', function(Blueprint $table) {
			$table->dropForeign('member_nutritionist_nutritionist_id_foreign');
		});
	}
}