<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParticipanteTbTable extends Migration {

	public function up()
	{
		Schema::create('participanteTb', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nome', 150)->nullable();
			$table->enum('sexo', array('Masculino', 'Feminino'))->nullable();
			$table->date('nascimento');
			$table->string('endereco', 250)->nullable();
			$table->string('complemento', 250);
			$table->string('bairro', 100)->nullable();
			$table->string('cidade', 100)->nullable();
			$table->string('cep', 10)->default('99.999-999');
			$table->enum('estadoCivil', array('Solteiro', 'casado', 'Viúvo', 'Divorciado', 'Outros'))->nullable();
			$table->string('email', 150)->unique();
			$table->string('telefone', 13)->default('(99)9999-9999');
			$table->string('celular1', 14)->default('(99)99999-9999');
			$table->string('celular2', 14)->default('(99)99999-9999');
			$table->string('convidadoPor', 150);
			$table->enum('diaVisita', array('Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado', 'Domingo'))->nullable();
			$table->time('horario');
			$table->date('dataConversao');
			$table->enum('tipoConversao', array('Conversão', 'Reconciliação'));
			$table->string('consolidador', 150);
			$table->enum('tipoParticipante', array('Visitante', 'Convertido', 'Membro'))->nullable();
			$table->datetime('update')->nullable();
			$table->string('userCad', 150)->nullable();
			$table->integer('idCelula')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('participanteTb');
	}
}