<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('celulaTb', function(Blueprint $table) {
			$table->foreign('celulaMae')->references('id')->on('celulaTb')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('celulaTb', function(Blueprint $table) {
			$table->foreign('idIgreja')->references('id')->on('igrejaTb')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('celula_supervisor', function(Blueprint $table) {
			$table->foreign('idCelula')->references('id')->on('celulaTb')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('celula_supervisor', function(Blueprint $table) {
			$table->foreign('idSupervisor')->references('id')->on('supervisorTb')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('participanteTb', function(Blueprint $table) {
			$table->foreign('idCelula')->references('id')->on('celulaTb')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('celulaTb', function(Blueprint $table) {
			$table->dropForeign('celulaTb_celulaMae_foreign');
		});
		Schema::table('celulaTb', function(Blueprint $table) {
			$table->dropForeign('celulaTb_idIgreja_foreign');
		});
		Schema::table('celula_supervisor', function(Blueprint $table) {
			$table->dropForeign('celula_supervisor_idCelula_foreign');
		});
		Schema::table('celula_supervisor', function(Blueprint $table) {
			$table->dropForeign('celula_supervisor_idSupervisor_foreign');
		});
		Schema::table('participanteTb', function(Blueprint $table) {
			$table->dropForeign('participanteTb_idCelula_foreign');
		});
	}
}