<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsUsersTable extends Migration {

	public function up()
	{
		Schema::create('notifications_users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('notification_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('metadata_custom')->unsigned();
			$table->boolean('view')->nullable()->default(false);
		});
	}

	public function down()
	{
		Schema::drop('notifications_users');
	}
}