<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->foreign('rol_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata_values')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('layout_id')->references('id')->on('layouts')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('notifications_users', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('notifications')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('notifications_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('notifications_users', function(Blueprint $table) {
			$table->foreign('metadata_custom')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_appdata', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_appdata', function(Blueprint $table) {
			$table->foreign('level_id')->references('id')->on('levels')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('interests', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('formats', function(Blueprint $table) {
			$table->foreign('parent_format_id')->references('id')->on('formats')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('formats', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('alerts')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->foreign('billing_data_id')->references('id')->on('billing_datas')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('files')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('languages', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('fields_formats', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('zones', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('users_logins', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('banners', function(Blueprint $table) {
			$table->foreign('img_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('banners', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('support_id')->references('id')->on('supports')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('format_id')->references('id')->on('formats')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('contracttype_id')->references('id')->on('contracts_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('price_id')->references('id')->on('price')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('fields', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('budgets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('tags', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('support_tags', function(Blueprint $table) {
			$table->foreign('support_id')->references('id')->on('supports')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('support_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('billing_datas', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('billing_datas', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('billing_datas', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ages', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('conditions', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('offers_tags', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('audiences', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('images_supports', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('files')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('images_supports', function(Blueprint $table) {
			$table->foreign('support_id')->references('id')->on('supports')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('offer_status', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offer_status', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('status', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->foreign('price_id')->references('id')->on('price')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->foreign('default_invoice_type_id')->references('id')->on('invoices_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_adevertiser_config', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_adevertiser_config', function(Blueprint $table) {
			$table->foreign('discount_id')->references('id')->on('discounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_adevertiser_config', function(Blueprint $table) {
			$table->foreign('price_id')->references('id')->on('price')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('event_type')->references('id')->on('event_types')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('stages', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('stage_supports', function(Blueprint $table) {
			$table->foreign('support_id')->references('id')->on('supports')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stage_supports', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stages')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('payment_methods', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('contact_phones', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('price_id')->references('id')->on('price')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('format_id')->references('id')->on('formats')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('metadata_values', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('metadata_values', function(Blueprint $table) {
			$table->foreign('locale_id')->references('id')->on('locales')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('price', function(Blueprint $table) {
			$table->foreign('default_discount')->references('id')->on('discounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('price', function(Blueprint $table) {
			$table->foreign('default_price_value')->references('id')->on('price_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->foreign('price_id')->references('id')->on('price')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('locales', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('metadata', function(Blueprint $table) {
			$table->foreign('default_value')->references('id')->on('metadata_values')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('offer_stages', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('offer_stages', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_movements', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('price_values', function(Blueprint $table) {
			$table->foreign('price_id')->references('id')->on('price')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('price_values', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('offer_audiences', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offer_audiences', function(Blueprint $table) {
			$table->foreign('audience_id')->references('id')->on('audiences')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('support_audience', function(Blueprint $table) {
			$table->foreign('support_id')->references('id')->on('supports')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('support_audience', function(Blueprint $table) {
			$table->foreign('audience_id')->references('id')->on('audiences')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('currencies', function(Blueprint $table) {
			$table->foreign('metdata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('searches', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('searches', function(Blueprint $table) {
			$table->foreign('format_id')->references('id')->on('formats')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('searches', function(Blueprint $table) {
			$table->foreign('session_id')->references('id')->on('sessions')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('searches', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('cms_category_id')->references('id')->on('cms_categories')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('page_type_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('layouts', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('content_blocks', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('content_block_layouts', function(Blueprint $table) {
			$table->foreign('content_block_id')->references('id')->on('content_blocks')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('content_block_layouts', function(Blueprint $table) {
			$table->foreign('layout_id')->references('id')->on('layouts')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cms_categories', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cms_categories', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('email_type', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('email_type', function(Blueprint $table) {
			$table->foreign('layout_id')->references('id')->on('layouts')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('levels', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('offer_paymentstypes_id')->references('id')->on('offers_paymenttypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_billings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_billings', function(Blueprint $table) {
			$table->foreign('billing_data_id')->references('id')->on('billing_datas')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('event_types', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_contacts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_contacts', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('alert_id')->references('id')->on('alerts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('mail_id')->references('id')->on('email_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('message_id')->references('id')->on('messages')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('subscribers', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('notifications_subscribers', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('notifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications_subscribers', function(Blueprint $table) {
			$table->foreign('subscribers_id')->references('id')->on('subscribers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('format_data', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('format_data', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('event_type_notifications', function(Blueprint $table) {
			$table->foreign('event_type_id')->references('id')->on('event_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('event_type_notifications', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('notifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('invoicefile_id')->references('id')->on('files')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('payment_method')->references('id')->on('payment_methods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('invoice_type_id')->references('id')->on('invoices_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('budgets_offers', function(Blueprint $table) {
			$table->foreign('budget_id')->references('id')->on('budgets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('budgets_offers', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('conditions_offers', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('conditions_offers', function(Blueprint $table) {
			$table->foreign('condition_id')->references('id')->on('conditions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers_prices', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers_prices', function(Blueprint $table) {
			$table->foreign('price_id')->references('id')->on('price')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages_types', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('equipments_offers', function(Blueprint $table) {
			$table->foreign('equipment_id')->references('id')->on('equipments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equipments_offers', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equipments_offers', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('data_reservations', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('data_reservations', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice_stages', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_reservations', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_reservations', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_reservations', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('budgets_services', function(Blueprint $table) {
			$table->foreign('budget_id')->references('id')->on('budgets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('budgets_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_services', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts_types', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts_types', function(Blueprint $table) {
			$table->foreign('layout_id')->references('id')->on('layouts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices_types', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices_types', function(Blueprint $table) {
			$table->foreign('layout_id')->references('id')->on('layouts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contractstypes_formats', function(Blueprint $table) {
			$table->foreign('contracttype_id')->references('id')->on('contracts_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contractstypes_formats', function(Blueprint $table) {
			$table->foreign('format_id')->references('id')->on('formats')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('paymentstypes', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers_paymenttypes', function(Blueprint $table) {
			$table->foreign('paymentstypes_id')->references('id')->on('paymentstypes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers_paymenttypes', function(Blueprint $table) {
			$table->foreign('metadata_id')->references('id')->on('metadata')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_image_id_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_metadata_id_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_user_id_foreign');
		});
		Schema::table('users_roles', function(Blueprint $table) {
			$table->dropForeign('users_roles_rol_id_foreign');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->dropForeign('roles_permissions_role_id_foreign');
		});
		Schema::table('roles_permissions', function(Blueprint $table) {
			$table->dropForeign('roles_permissions_permission_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_category_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_metadata_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_metadata_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_layout_id_foreign');
		});
		Schema::table('notifications_users', function(Blueprint $table) {
			$table->dropForeign('notifications_users_notification_id_foreign');
		});
		Schema::table('notifications_users', function(Blueprint $table) {
			$table->dropForeign('notifications_users_user_id_foreign');
		});
		Schema::table('notifications_users', function(Blueprint $table) {
			$table->dropForeign('notifications_users_metadata_custom_foreign');
		});
		Schema::table('user_appdata', function(Blueprint $table) {
			$table->dropForeign('user_appdata_user_id_foreign');
		});
		Schema::table('user_appdata', function(Blueprint $table) {
			$table->dropForeign('user_appdata_level_id_foreign');
		});
		Schema::table('interests', function(Blueprint $table) {
			$table->dropForeign('interests_metadata_id_foreign');
		});
		Schema::table('formats', function(Blueprint $table) {
			$table->dropForeign('formats_parent_format_id_foreign');
		});
		Schema::table('formats', function(Blueprint $table) {
			$table->dropForeign('formats_metadata_id_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_metadata_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_metadata_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_metadata_id_foreign');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->dropForeign('supports_category_id_foreign');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->dropForeign('supports_language_id_foreign');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->dropForeign('supports_billing_data_id_foreign');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->dropForeign('supports_image_id_foreign');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->dropForeign('supports_metadata_id_foreign');
		});
		Schema::table('languages', function(Blueprint $table) {
			$table->dropForeign('languages_metadata_id_foreign');
		});
		Schema::table('fields_formats', function(Blueprint $table) {
			$table->dropForeign('fields_formats_field_id_foreign');
		});
		Schema::table('zones', function(Blueprint $table) {
			$table->dropForeign('zones_metadata_id_foreign');
		});
		Schema::table('users_logins', function(Blueprint $table) {
			$table->dropForeign('users_logins_user_id_foreign');
		});
		Schema::table('banners', function(Blueprint $table) {
			$table->dropForeign('banners_img_id_foreign');
		});
		Schema::table('banners', function(Blueprint $table) {
			$table->dropForeign('banners_metadata_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_support_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_format_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_image_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_contracttype_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_metadata_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_price_id_foreign');
		});
		Schema::table('fields', function(Blueprint $table) {
			$table->dropForeign('fields_metadata_id_foreign');
		});
		Schema::table('budgets', function(Blueprint $table) {
			$table->dropForeign('budgets_user_id_foreign');
		});
		Schema::table('tags', function(Blueprint $table) {
			$table->dropForeign('tags_metadata_id_foreign');
		});
		Schema::table('support_tags', function(Blueprint $table) {
			$table->dropForeign('support_tags_support_id_foreign');
		});
		Schema::table('support_tags', function(Blueprint $table) {
			$table->dropForeign('support_tags_tag_id_foreign');
		});
		Schema::table('billing_datas', function(Blueprint $table) {
			$table->dropForeign('billing_datas_country_id_foreign');
		});
		Schema::table('billing_datas', function(Blueprint $table) {
			$table->dropForeign('billing_datas_state_id_foreign');
		});
		Schema::table('billing_datas', function(Blueprint $table) {
			$table->dropForeign('billing_datas_payment_method_id_foreign');
		});
		Schema::table('ages', function(Blueprint $table) {
			$table->dropForeign('ages_metadata_id_foreign');
		});
		Schema::table('conditions', function(Blueprint $table) {
			$table->dropForeign('conditions_metadata_id_foreign');
		});
		Schema::table('offers_tags', function(Blueprint $table) {
			$table->dropForeign('offers_tags_offer_id_foreign');
		});
		Schema::table('offers_tags', function(Blueprint $table) {
			$table->dropForeign('offers_tags_tag_id_foreign');
		});
		Schema::table('audiences', function(Blueprint $table) {
			$table->dropForeign('audiences_metadata_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_metadata_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_user_id_foreign');
		});
		Schema::table('images_supports', function(Blueprint $table) {
			$table->dropForeign('images_supports_image_id_foreign');
		});
		Schema::table('images_supports', function(Blueprint $table) {
			$table->dropForeign('images_supports_support_id_foreign');
		});
		Schema::table('offer_status', function(Blueprint $table) {
			$table->dropForeign('offer_status_offer_id_foreign');
		});
		Schema::table('offer_status', function(Blueprint $table) {
			$table->dropForeign('offer_status_status_id_foreign');
		});
		Schema::table('status', function(Blueprint $table) {
			$table->dropForeign('status_metadata_id_foreign');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->dropForeign('settings_price_id_foreign');
		});
		Schema::table('settings', function(Blueprint $table) {
			$table->dropForeign('settings_default_invoice_type_id_foreign');
		});
		Schema::table('user_adevertiser_config', function(Blueprint $table) {
			$table->dropForeign('user_adevertiser_config_user_id_foreign');
		});
		Schema::table('user_adevertiser_config', function(Blueprint $table) {
			$table->dropForeign('user_adevertiser_config_discount_id_foreign');
		});
		Schema::table('user_adevertiser_config', function(Blueprint $table) {
			$table->dropForeign('user_adevertiser_config_price_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_event_type_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_user_id_foreign');
		});
		Schema::table('stages', function(Blueprint $table) {
			$table->dropForeign('stages_metadata_id_foreign');
		});
		Schema::table('stage_supports', function(Blueprint $table) {
			$table->dropForeign('stage_supports_support_id_foreign');
		});
		Schema::table('stage_supports', function(Blueprint $table) {
			$table->dropForeign('stage_supports_stage_id_foreign');
		});
		Schema::table('payment_methods', function(Blueprint $table) {
			$table->dropForeign('payment_methods_metadata_id_foreign');
		});
		Schema::table('contact_phones', function(Blueprint $table) {
			$table->dropForeign('contact_phones_contact_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_metadata_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_price_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_format_id_foreign');
		});
		Schema::table('metadata_values', function(Blueprint $table) {
			$table->dropForeign('metadata_values_metadata_id_foreign');
		});
		Schema::table('metadata_values', function(Blueprint $table) {
			$table->dropForeign('metadata_values_locale_id_foreign');
		});
		Schema::table('price', function(Blueprint $table) {
			$table->dropForeign('price_default_discount_foreign');
		});
		Schema::table('price', function(Blueprint $table) {
			$table->dropForeign('price_default_price_value_foreign');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->dropForeign('discounts_price_id_foreign');
		});
		Schema::table('locales', function(Blueprint $table) {
			$table->dropForeign('locales_metadata_id_foreign');
		});
		Schema::table('metadata', function(Blueprint $table) {
			$table->dropForeign('metadata_default_value_foreign');
		});
		Schema::table('offer_stages', function(Blueprint $table) {
			$table->dropForeign('offer_stages_stage_id_foreign');
		});
		Schema::table('offer_stages', function(Blueprint $table) {
			$table->dropForeign('offer_stages_offer_id_foreign');
		});
		Schema::table('user_movements', function(Blueprint $table) {
			$table->dropForeign('user_movements_user_id_foreign');
		});
		Schema::table('price_values', function(Blueprint $table) {
			$table->dropForeign('price_values_price_id_foreign');
		});
		Schema::table('price_values', function(Blueprint $table) {
			$table->dropForeign('price_values_currency_id_foreign');
		});
		Schema::table('offer_audiences', function(Blueprint $table) {
			$table->dropForeign('offer_audiences_offer_id_foreign');
		});
		Schema::table('offer_audiences', function(Blueprint $table) {
			$table->dropForeign('offer_audiences_audience_id_foreign');
		});
		Schema::table('support_audience', function(Blueprint $table) {
			$table->dropForeign('support_audience_support_id_foreign');
		});
		Schema::table('support_audience', function(Blueprint $table) {
			$table->dropForeign('support_audience_audience_id_foreign');
		});
		Schema::table('currencies', function(Blueprint $table) {
			$table->dropForeign('currencies_metdata_id_foreign');
		});
		Schema::table('searches', function(Blueprint $table) {
			$table->dropForeign('searches_category_id_foreign');
		});
		Schema::table('searches', function(Blueprint $table) {
			$table->dropForeign('searches_format_id_foreign');
		});
		Schema::table('searches', function(Blueprint $table) {
			$table->dropForeign('searches_session_id_foreign');
		});
		Schema::table('searches', function(Blueprint $table) {
			$table->dropForeign('searches_user_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_metadata_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_cms_category_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_page_type_id_foreign');
		});
		Schema::table('layouts', function(Blueprint $table) {
			$table->dropForeign('layouts_metadata_id_foreign');
		});
		Schema::table('content_blocks', function(Blueprint $table) {
			$table->dropForeign('content_blocks_metadata_id_foreign');
		});
		Schema::table('content_block_layouts', function(Blueprint $table) {
			$table->dropForeign('content_block_layouts_content_block_id_foreign');
		});
		Schema::table('content_block_layouts', function(Blueprint $table) {
			$table->dropForeign('content_block_layouts_layout_id_foreign');
		});
		Schema::table('cms_categories', function(Blueprint $table) {
			$table->dropForeign('cms_categories_metadata_id_foreign');
		});
		Schema::table('cms_categories', function(Blueprint $table) {
			$table->dropForeign('cms_categories_page_id_foreign');
		});
		Schema::table('email_type', function(Blueprint $table) {
			$table->dropForeign('email_type_metadata_id_foreign');
		});
		Schema::table('email_type', function(Blueprint $table) {
			$table->dropForeign('email_type_layout_id_foreign');
		});
		Schema::table('levels', function(Blueprint $table) {
			$table->dropForeign('levels_metadata_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_offer_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_contract_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_offer_paymentstypes_id_foreign');
		});
		Schema::table('user_billings', function(Blueprint $table) {
			$table->dropForeign('user_billings_user_id_foreign');
		});
		Schema::table('user_billings', function(Blueprint $table) {
			$table->dropForeign('user_billings_billing_data_id_foreign');
		});
		Schema::table('event_types', function(Blueprint $table) {
			$table->dropForeign('event_types_metadata_id_foreign');
		});
		Schema::table('user_contacts', function(Blueprint $table) {
			$table->dropForeign('user_contacts_user_id_foreign');
		});
		Schema::table('user_contacts', function(Blueprint $table) {
			$table->dropForeign('user_contacts_contact_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_metadata_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_alert_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_mail_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_message_id_foreign');
		});
		Schema::table('subscribers', function(Blueprint $table) {
			$table->dropForeign('subscribers_metadata_id_foreign');
		});
		Schema::table('notifications_subscribers', function(Blueprint $table) {
			$table->dropForeign('notifications_subscribers_notification_id_foreign');
		});
		Schema::table('notifications_subscribers', function(Blueprint $table) {
			$table->dropForeign('notifications_subscribers_subscribers_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_metadata_id_foreign');
		});
		Schema::table('format_data', function(Blueprint $table) {
			$table->dropForeign('format_data_offer_id_foreign');
		});
		Schema::table('format_data', function(Blueprint $table) {
			$table->dropForeign('format_data_field_id_foreign');
		});
		Schema::table('event_type_notifications', function(Blueprint $table) {
			$table->dropForeign('event_type_notifications_event_type_id_foreign');
		});
		Schema::table('event_type_notifications', function(Blueprint $table) {
			$table->dropForeign('event_type_notifications_notification_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_invoicefile_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_payment_method_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_invoice_type_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_metadata_id_foreign');
		});
		Schema::table('budgets_offers', function(Blueprint $table) {
			$table->dropForeign('budgets_offers_budget_id_foreign');
		});
		Schema::table('budgets_offers', function(Blueprint $table) {
			$table->dropForeign('budgets_offers_offer_id_foreign');
		});
		Schema::table('conditions_offers', function(Blueprint $table) {
			$table->dropForeign('conditions_offers_offer_id_foreign');
		});
		Schema::table('conditions_offers', function(Blueprint $table) {
			$table->dropForeign('conditions_offers_condition_id_foreign');
		});
		Schema::table('offers_prices', function(Blueprint $table) {
			$table->dropForeign('offers_prices_offer_id_foreign');
		});
		Schema::table('offers_prices', function(Blueprint $table) {
			$table->dropForeign('offers_prices_price_id_foreign');
		});
		Schema::table('pages_types', function(Blueprint $table) {
			$table->dropForeign('pages_types_metadata_id_foreign');
		});
		Schema::table('equipments', function(Blueprint $table) {
			$table->dropForeign('equipments_metadata_id_foreign');
		});
		Schema::table('equipments_offers', function(Blueprint $table) {
			$table->dropForeign('equipments_offers_equipment_id_foreign');
		});
		Schema::table('equipments_offers', function(Blueprint $table) {
			$table->dropForeign('equipments_offers_offer_id_foreign');
		});
		Schema::table('equipments_offers', function(Blueprint $table) {
			$table->dropForeign('equipments_offers_metadata_id_foreign');
		});
		Schema::table('data_reservations', function(Blueprint $table) {
			$table->dropForeign('data_reservations_offer_id_foreign');
		});
		Schema::table('data_reservations', function(Blueprint $table) {
			$table->dropForeign('data_reservations_metadata_id_foreign');
		});
		Schema::table('invoice_stages', function(Blueprint $table) {
			$table->dropForeign('invoice_stages_stage_id_foreign');
		});
		Schema::table('invoice_reservations', function(Blueprint $table) {
			$table->dropForeign('invoice_reservations_invoice_id_foreign');
		});
		Schema::table('invoice_reservations', function(Blueprint $table) {
			$table->dropForeign('invoice_reservations_metadata_id_foreign');
		});
		Schema::table('invoice_reservations', function(Blueprint $table) {
			$table->dropForeign('invoice_reservations_reservation_id_foreign');
		});
		Schema::table('budgets_services', function(Blueprint $table) {
			$table->dropForeign('budgets_services_budget_id_foreign');
		});
		Schema::table('budgets_services', function(Blueprint $table) {
			$table->dropForeign('budgets_services_service_id_foreign');
		});
		Schema::table('invoice_services', function(Blueprint $table) {
			$table->dropForeign('invoice_services_service_id_foreign');
		});
		Schema::table('invoice_services', function(Blueprint $table) {
			$table->dropForeign('invoice_services_metadata_id_foreign');
		});
		Schema::table('contracts_types', function(Blueprint $table) {
			$table->dropForeign('contracts_types_metadata_id_foreign');
		});
		Schema::table('contracts_types', function(Blueprint $table) {
			$table->dropForeign('contracts_types_layout_id_foreign');
		});
		Schema::table('invoices_types', function(Blueprint $table) {
			$table->dropForeign('invoices_types_metadata_id_foreign');
		});
		Schema::table('invoices_types', function(Blueprint $table) {
			$table->dropForeign('invoices_types_layout_id_foreign');
		});
		Schema::table('contractstypes_formats', function(Blueprint $table) {
			$table->dropForeign('contractstypes_formats_contracttype_id_foreign');
		});
		Schema::table('contractstypes_formats', function(Blueprint $table) {
			$table->dropForeign('contractstypes_formats_format_id_foreign');
		});
		Schema::table('paymentstypes', function(Blueprint $table) {
			$table->dropForeign('paymentstypes_metadata_id_foreign');
		});
		Schema::table('offers_paymenttypes', function(Blueprint $table) {
			$table->dropForeign('offers_paymenttypes_paymentstypes_id_foreign');
		});
		Schema::table('offers_paymenttypes', function(Blueprint $table) {
			$table->dropForeign('offers_paymenttypes_metadata_id_foreign');
		});
	}
}