<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormDefinition extends Model 
{

    protected $table = 'FormDefinition';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('groupID', 'userID', 'submissionsStart', 'submissionsEnd', 'scoresDue', 'fields', 'status');
    protected $visible = array('groupID', 'userID', 'submissionsStart', 'submissionsEnd', 'scoresDue', 'fields', 'status');

    public function submissions()
    {
        return $this->hasMany('ApplicationSubmission', 'form_id');
    }

}