<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Groups extends Model 
{

    protected $table = 'Groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description');
    protected $visible = array('name', 'description');

    public function users()
    {
        return $this->belongsToMany('Users', 'id', 'id');
    }

}