<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorksTable extends Migration {

	public function up()
	{
		Schema::create('works', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->longText('des');
			$table->integer('user_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('seo_title')->nullable();
			$table->longText('seo_des')->nullable();
			$table->string('seo_keywords')->nullable();
			$table->enum('status', array('open', 'close'));
			$table->boolean('activate')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('works');
	}
}